//kang
#include <QtGui>
#include "MainForm.h"
#include "ConnectionForm.h"
#include "DebugModeValue.h"

DebugModeValue::DebugModeValue(QWidget* parent = 0)
{
	CreateValueInput();
	returnValue = "";
	items.clear();
}

DebugModeValue::~DebugModeValue()
{
}

/*=======================================================
// DebugModeValue - ListView UI 
========================================================*/
void DebugModeValue::CreateValueInput()
{
	parameterGroup = new QGroupBox(tr("Parameter"));
	
	parameterValue = new QListWidget;
		
	parameterLayout = new QGridLayout;	
	parameterLayout->addWidget(parameterValue, 0, 0);
	parameterGroup->setLayout(parameterLayout);
	
	inputGroup = new QGroupBox(tr("INPUT"));
	
	inputLabel = new QLabel(tr("Data Type:"));
	inputComboBox = new QComboBox;
	inputComboBox->addItem(tr("INT"));
	//kang
	inputComboBox->addItem(tr("CHAR"));
	inputComboBox->addItem(tr("VARCHAR"));
	inputComboBox->addItem(tr("FLOAT"));
	
	inputLabel2 = new QLabel(tr("Value:"));
	inputLineEdit = new QLineEdit;

	inputLayout = new QGridLayout;
	inputLayout->addWidget(inputLabel, 0, 0);
	inputLayout->addWidget(inputComboBox, 0, 1);
	inputLayout->addWidget(inputLabel2, 1, 0);
	inputLayout->addWidget(inputLineEdit, 1, 1);
	inputGroup->setLayout(inputLayout);
	
	buttonGroup = new QGroupBox();
	okbutton = new QPushButton(tr("OK"));
	cancelbutton = new QPushButton(tr("Cancel"));
	
	buttonLayout = new QGridLayout;
	buttonLayout->addWidget(okbutton, 0, 0);
	buttonLayout->addWidget(cancelbutton, 0, 1);
	buttonGroup->setLayout(buttonLayout);
	
	connect(okbutton, SIGNAL(clicked()),this,SLOT(OkButtonPress()));
	connect(cancelbutton, SIGNAL(clicked()), this, SLOT(Close()));
	
	layout = new QGridLayout;
	layout->addWidget(parameterGroup, 0, 0);
	layout->addWidget(inputGroup, 1, 0);
	layout->addWidget(buttonGroup, 2,0);
	setLayout(layout);
	
	setWindowTitle(tr("Line Edits"));

	MainForm* mainForm = ConnectionForm::getInstance()->GetMainForm();
	mainForm->setEnabled(false);
	
	for(int i = 0; i < mainForm->listvalue1.count(); i++)
	{
		QString buffer = mainForm->listvalue1[i];
		parameterValue->addItem(buffer); 
	}

	if( parameterValue->count() == 1)
	{
		connect(parameterValue, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(Slot_Value()));
	}
	else
		connect(parameterValue, SIGNAL(currentItemChanged(QListWidgetItem*, QListWidgetItem*)), this, SLOT(Slot_ValueChange(QListWidgetItem*, QListWidgetItem*)));

}

void DebugModeValue::OkButtonPress()
{
	if( this->parameterValue->count() > this->items.count() )
	{
		Item* item = new Item();
		item->name = inputLineEdit->displayText();
		item->index = this->items.count();
		
		if ((inputComboBox->currentText() == "INT") || (inputComboBox->currentText() == "FLOAT"))
		{
			items << item;
		}
		else if((inputComboBox->currentText() == "VARCHAR") || (inputComboBox->currentText() == "CHAR"))
		{
			QString i = item->name;
			QString j = "\'" +i + "\'";
			item->name = j;
			items << item;
		}
	}

qDebug()<<"aaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
	MainForm* mainForm = ConnectionForm::getInstance()->GetMainForm();
	mainForm->setEnabled(true);
	this->close();
	mainForm->StepInto();
	qDebug()<<"bbbbbbbbbbbbbbbbbbbbbbbbb";
}

void DebugModeValue::Slot_Value()
{
	connect(inputLineEdit, SIGNAL(textChanged(QString)), this, SLOT(Slot_Value_Return()));
}

void DebugModeValue::Slot_Value_Return()
{
	if ((inputComboBox->currentText() == "INT") || (inputComboBox->currentText() == "FLOAT"))
	{
		returnValue = inputLineEdit->displayText();
	}
	else if((inputComboBox->currentText() == "VARCHAR") || (inputComboBox->currentText() == "CHAR"))
	{
		QString i = inputLineEdit->displayText();
		QString j = "\'" +i + "\'";
		returnValue = j;
	}
	else
		returnValue = inputLineEdit->displayText();
	qDebug()<< returnValue;	
}

void DebugModeValue::Slot_ValueChange(QListWidgetItem* currentItem, QListWidgetItem* previousItem)
{
	Item* item = new Item();
	item->name = inputLineEdit->displayText();
	int i=0;

	for( i = 0; i < parameterValue->count(); i++)
	{
		if(parameterValue->item(i) == previousItem)
		{
			item->index = i;
			break;
		}
	}
	
	int state = 0;
	
	for(i = 0; i < items.count(); i++)
	{
		if(items[i]->index == item->index)
		{
			state = 1;
			break;
		}
	}

	if( state == 1 )
	{
		items.replace(i, item);
	}

	else
	{
		if ((inputComboBox->currentText() == "INT") || (inputComboBox->currentText() == "FLOAT"))
		{
			items << item;
		}
		else if((inputComboBox->currentText() == "VARCHAR") || (inputComboBox->currentText() == "CHAR"))
		{
			QString i = item->name;
			QString j = "\'" +i + "\'";
			item->name = j;
			items << item;
		}
	}

	this->inputLineEdit->clear();
}

void DebugModeValue::Close()
{
	MainForm* mainForm = ConnectionForm::getInstance()->GetMainForm();
	mainForm->setEnabled(true);
	this->close();
}

